using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace MovieListing
		{
			
			
			public class MoviesBO : StrataFlix.Business.MoviesBO
			{
				
				
				#region " Private Fields "
				
				private static bool _AreCustomDescriptorsEvaluated = false;
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Determine if the custom descriptors are going to be evaluated
				/// </summary>
				/// <remarks></remarks>
				protected override bool AreCustomDescriptorsEvaluated
				{
					get
					{
						//-- Establish Locals
						bool r = _AreCustomDescriptorsEvaluated;
						
						//-- Do not eval the desciptors again
						_AreCustomDescriptorsEvaluated = true;
						
						//-- Return results
						return r;
					}
				}
				
				/// <summary>
				/// Add additional binding fields
				/// </summary>
				/// <remarks></remarks>
				protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
				{
					//-- Establish Locals
					List<FieldPropertyDescriptor> r = new List<FieldPropertyDescriptor>();
					
					//-- Include all of the base descriptors
					try
					{
						r.AddRange(base.GetCustomBindablePropertyDescriptors());
					}
					catch (Exception)
					{
					}
					
					//-- Add the custom descriptors
					r.Add(new ReflectionPropertyDescriptor("mv_RatingText", typeof(MoviesBO)));
					
					//-- Return results
					return r.ToArray();
				}
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// Rating text
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				[Browsable(false), BusinessFieldDisplayInEditor(), Description("Rating - Text Format"), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public string mv_RatingText
				{
					get
					{
						return MicroFour.StrataFrame.Tools.Common.GetEnumDisplayValue(mv_Rating);
					}
				}
				
				#endregion
				
			}
			
			
		}
	}
}
